/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.data.recipe.builder;

import cloud.lemonslice.teastory.recipe.stone_mill.StoneMillRecipe;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.craft.FluidIngredient;
import xueluoanping.teastory.registry.RecipeRegister;

public class StoneMillRecipeBuilder {
    private final FluidIngredient inputFluid;
    private final Ingredient inputItem;
    private final NonNullList<ItemStack> outputItems;
    private final FluidStack outputFluid;
    private final int workTime;

    private StoneMillRecipeBuilder(Ingredient inputItem, FluidIngredient inputFluid, NonNullList<ItemStack> outputItems, FluidStack outputFluid, int workTime) {
        this.inputItem = inputItem;
        this.inputFluid = inputFluid;
        this.outputItems = outputItems;
        this.outputFluid = outputFluid;
        this.workTime = workTime;
    }

    public static StoneMillRecipeBuilder recipe(int workTime, Ingredient inputItem, FluidIngredient inputFluid, FluidStack outputFluid, ItemStack ... outputItems) {
        return new StoneMillRecipeBuilder(inputItem, inputFluid, (NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])outputItems), outputFluid, workTime);
    }

    public static StoneMillRecipeBuilder recipeWithDefaultTime(Ingredient inputItem, FluidIngredient inputFluid, FluidStack outputFluid, ItemStack ... outputItems) {
        return StoneMillRecipeBuilder.recipe(200, inputItem, inputFluid, outputFluid, outputItems);
    }

    public static StoneMillRecipeBuilder recipeWithoutFluid(int workTime, Ingredient inputItem, ItemStack ... outputItems) {
        return StoneMillRecipeBuilder.recipe(workTime, inputItem, FluidIngredient.EMPTY, FluidStack.EMPTY, outputItems);
    }

    public static StoneMillRecipeBuilder recipeWithDefaultTimeWithoutFluid(Ingredient inputItem, ItemStack ... outputItems) {
        return StoneMillRecipeBuilder.recipeWithoutFluid(200, inputItem, outputItems);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, String save) {
        ResourceLocation saveRes = ResourceLocation.m_135820_((String)save);
        this.build(consumerIn, saveRes);
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.inputItem, this.inputFluid, this.outputItems, this.outputFluid, this.workTime));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        protected final FluidIngredient inputFluid;
        protected final Ingredient inputItem;
        protected final NonNullList<ItemStack> outputItems;
        protected final FluidStack outputFluid;
        protected final int workTime;
        private final RecipeSerializer<StoneMillRecipe> serializer = (RecipeSerializer)RecipeRegister.STONE_MILL_SERIALIZER.get();

        public Result(ResourceLocation idIn, Ingredient inputItem, FluidIngredient inputFluid, NonNullList<ItemStack> outputItems, FluidStack outputFluid, int workTime) {
            this.id = TeaStory.rl(idIn.m_135827_(), "stone_mill/" + idIn.m_135815_());
            this.inputItem = inputItem;
            this.inputFluid = inputFluid;
            this.outputItems = outputItems;
            this.outputFluid = outputFluid;
            this.workTime = workTime;
        }

        public void m_7917_(JsonObject json) {
            if (this.inputFluid.matchingFluidStacks != null && !this.inputFluid.getMatchingFluidStacks().isEmpty()) {
                json.add("fluid_ingredient", (JsonElement)this.inputFluid.serialize());
            }
            if (!this.inputItem.checkInvalidation()) {
                json.add("item_ingredient", this.inputItem.m_43942_());
            }
            JsonArray jsonarray = new JsonArray();
            boolean use = false;
            for (ItemStack itemStack : this.outputItems) {
                if (itemStack.m_41619_()) continue;
                JsonObject jsonItem = new JsonObject();
                jsonItem.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
                if (itemStack.m_41613_() > 1) {
                    jsonItem.addProperty("count", (Number)itemStack.m_41613_());
                }
                jsonarray.add((JsonElement)jsonItem);
                use = true;
            }
            if (use) {
                json.add("output_items", (JsonElement)jsonarray);
            }
            if (!this.outputFluid.isEmpty()) {
                JsonObject jsonItem = new JsonObject();
                jsonItem.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.outputFluid.getFluid()).toString());
                jsonItem.addProperty("amount", (Number)this.outputFluid.getAmount());
                json.add("output_fluid", (JsonElement)jsonItem);
            }
            json.addProperty("work_time", (Number)this.workTime);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

